//	Draw4DGPUDefinitions.h
//
//	© 2025 by Jeff Weeks
//	See TermsOfUse.txt

#ifndef Draw4DGPUDefinitions_h
#define Draw4DGPUDefinitions_h

#include <simd/simd.h>


enum
{
	VertexAttributePosition	= 0,
	VertexAttributeNormal	= 1,
	VertexAttributeMisc		= 2
};

//	Buffer indices for vertex functions ("VF")
enum
{
	BufferIndexVFVertexAttributes	= 0,
	BufferIndexVFUniforms			= 1,
	BufferIndexVFInstanceData		= 2
};

//	Texture and sampler indices for fragment functions ("FF")
enum
{
	TextureIndexFFPrimary	= 0
};
enum
{
	SamplerIndexFFPrimary	= 0
};

//	Texture indices for compute functions ("CF")
enum
{
	TextureIndexCFDst	= 0
};

//	Buffer indices for compute functions ("CF")
enum
{
	BufferIndexCFGridLimits	= 0
};



typedef struct
{
	simd_float4x4	itsModelViewMatrix;
	simd_half3		itsRGB;		//	(R,G,B) for a single color (no premultiplied alpha!)
	__fp16			itsOpacity;	//	alpha value to be applied after specular highlighting
								//		(because we'll want to fade the specular highlighting
								//		along with the object's intrinsic color, in contrast
								//		to, say, drawing a glass object whose highlights
								//		are not transparent)
} Draw4DInstanceDataRGB;

typedef struct
{
	simd_float4x4	itsModelViewMatrix;
	simd_half3		itsHSV0,
					itsHSV1;
	__fp16			itsOpacity;
} Draw4DInstanceDataHSV;

typedef struct
{
	simd_float4x4	itsModelViewMatrix;
} Draw4DInstanceDataTex;

typedef struct
{
	simd_float4x4	itsProjectionMatrix;
} Draw4DUniformData;

#endif	//	Draw4DGPUDefinitions_h
